/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.EnumSet;
import java.util.Set;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.abel.EntityPortion;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandHideShowByVisibility
extends SingleLineCommand2<UmlDiagram> {
    public static final CommandHideShowByVisibility ME = new CommandHideShowByVisibility();

    private CommandHideShowByVisibility() {
        super(CommandHideShowByVisibility.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandHideShowByVisibility.class.getName(), RegexLeaf.start(), new RegexLeaf("COMMAND", "(hide|show)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("VISIBILITY", "((?:public|private|protected|package)?(?:[,%s]+(?:public|private|protected|package))*)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("PORTION", "(members?|attributes?|fields?|methods?)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(UmlDiagram classDiagram, LineLocation location, RegexResult arg) {
        if (classDiagram instanceof ClassDiagram) {
            return this.executeArgClass((ClassDiagram)classDiagram, arg);
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgClass(ClassDiagram classDiagram, RegexResult arg) {
        EntityPortion portion = this.getEntityPortion(arg.get("PORTION", 0));
        EnumSet<VisibilityModifier> visibilities = EnumSet.noneOf(VisibilityModifier.class);
        StringTokenizer st = new StringTokenizer(StringUtils.goLowerCase(arg.get("VISIBILITY", 0)), " ,");
        while (st.hasMoreTokens()) {
            this.addVisibilities(st.nextToken(), portion, visibilities);
        }
        classDiagram.hideOrShow(visibilities, arg.get("COMMAND", 0).equalsIgnoreCase("show"));
        return CommandExecutionResult.ok();
    }

    private void addVisibilities(String token, EntityPortion portion, Set<VisibilityModifier> result) {
        if (token.equals("public") && (portion == EntityPortion.MEMBER || portion == EntityPortion.FIELD)) {
            result.add(VisibilityModifier.PUBLIC_FIELD);
        }
        if (token.equals("public") && (portion == EntityPortion.MEMBER || portion == EntityPortion.METHOD)) {
            result.add(VisibilityModifier.PUBLIC_METHOD);
        }
        if (token.equals("private") && (portion == EntityPortion.MEMBER || portion == EntityPortion.FIELD)) {
            result.add(VisibilityModifier.PRIVATE_FIELD);
        }
        if (token.equals("private") && (portion == EntityPortion.MEMBER || portion == EntityPortion.METHOD)) {
            result.add(VisibilityModifier.PRIVATE_METHOD);
        }
        if (token.equals("protected") && (portion == EntityPortion.MEMBER || portion == EntityPortion.FIELD)) {
            result.add(VisibilityModifier.PROTECTED_FIELD);
        }
        if (token.equals("protected") && (portion == EntityPortion.MEMBER || portion == EntityPortion.METHOD)) {
            result.add(VisibilityModifier.PROTECTED_METHOD);
        }
        if (token.equals("package") && (portion == EntityPortion.MEMBER || portion == EntityPortion.FIELD)) {
            result.add(VisibilityModifier.PACKAGE_PRIVATE_FIELD);
        }
        if (token.equals("package") && (portion == EntityPortion.MEMBER || portion == EntityPortion.METHOD)) {
            result.add(VisibilityModifier.PACKAGE_PRIVATE_METHOD);
        }
    }

    private EntityPortion getEntityPortion(String s2) {
        String sub = StringUtils.goLowerCase(s2.substring(0, 3));
        if (sub.equals("met")) {
            return EntityPortion.METHOD;
        }
        if (sub.equals("mem")) {
            return EntityPortion.MEMBER;
        }
        if (sub.equals("att") || sub.equals("fie")) {
            return EntityPortion.FIELD;
        }
        throw new IllegalArgumentException();
    }
}

