/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.text;

import java.util.Objects;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.text.FoxSignature;
import net.sourceforge.plantuml.text.TLineType;
import net.sourceforge.plantuml.utils.LineLocation;

public final class StringLocated {
    private final String s;
    private final LineLocation location;
    private final String preprocessorError;
    private StringLocated trimmed;
    private long fox = -1L;
    private TLineType type;

    public StringLocated(String s2, LineLocation location) {
        this(s2, location, null);
    }

    public StringLocated(String s2, LineLocation location, String preprocessorError) {
        this.s = Objects.requireNonNull(s2);
        this.location = location;
        this.preprocessorError = preprocessorError;
    }

    public String toString() {
        return this.s;
    }

    public StringLocated append(String endOfLine) {
        return new StringLocated(this.s + endOfLine, this.location, this.preprocessorError);
    }

    public StringLocated mergeEndBackslash(StringLocated next) {
        if (!StringUtils.endsWithBackslash(this.s)) {
            throw new IllegalArgumentException();
        }
        return new StringLocated(this.s.substring(0, this.s.length() - 1) + next.s, this.location, this.preprocessorError);
    }

    public StringLocated withErrorPreprocessor(String preprocessorError) {
        return new StringLocated(this.s, this.location, preprocessorError);
    }

    public StringLocated substring(int start, int end) {
        return new StringLocated(this.getString().substring(start, end), this.getLocation(), this.getPreprocessorError());
    }

    public StringLocated substring(int start) {
        return new StringLocated(this.getString().substring(start), this.getLocation(), this.getPreprocessorError());
    }

    public StringLocated getTrimmed() {
        if (this.trimmed == null) {
            this.trimmed = new StringLocated(StringUtils.trin(this.getString()), this.location, this.preprocessorError);
            this.trimmed.fox = this.fox;
            this.trimmed.trimmed = this.trimmed;
        }
        return this.trimmed;
    }

    public StringLocated removeInnerComment() {
        int idx;
        String string = this.s.toString();
        String trim = string.replace('\t', ' ').trim();
        if (trim.startsWith("/'") && (idx = string.indexOf("'/")) != -1) {
            return new StringLocated(this.removeSpecialInnerComment(this.s.substring(idx + 2, this.s.length())), this.location, this.preprocessorError);
        }
        if (trim.endsWith("'/") && (idx = string.lastIndexOf("/'")) != -1) {
            return new StringLocated(this.removeSpecialInnerComment(this.s.substring(0, idx)), this.location, this.preprocessorError);
        }
        if (trim.contains("/'''") && trim.contains("'''/")) {
            return new StringLocated(this.removeSpecialInnerComment(this.s), this.location, this.preprocessorError);
        }
        return this;
    }

    private String removeSpecialInnerComment(String s2) {
        if (s2.contains("/'''") && s2.contains("'''/")) {
            return s2.replaceAll("/'''[-\\w]*'''/", "");
        }
        return s2;
    }

    public String getString() {
        return this.s;
    }

    public LineLocation getLocation() {
        return this.location;
    }

    public String getPreprocessorError() {
        return this.preprocessorError;
    }

    public long getFoxSignature() {
        if (this.fox == -1L) {
            this.fox = FoxSignature.getFoxSignatureFromRealString(this.getString());
        }
        return this.fox;
    }

    public TLineType getType() {
        if (this.type == null) {
            this.type = TLineType.getFromLineInternal(this.s);
        }
        return this.type;
    }

    public int length() {
        return this.s.length();
    }

    public char charAt(int i) {
        return this.s.charAt(i);
    }
}

