/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.stdlib;

import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.json.JsonArray;
import net.sourceforge.plantuml.json.JsonObject;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.tim.stdlib.SimpleReturnFunction;

public class GetJsonKey
extends SimpleReturnFunction {
    @Override
    public TFunctionSignature getSignature() {
        return new TFunctionSignature("%get_json_keys", 1);
    }

    @Override
    public boolean canCover(int nbArg, Set<String> namedArgument) {
        return nbArg == 1;
    }

    @Override
    public TValue executeReturnFunction(TContext context, TMemory memory, StringLocated location, List<TValue> values, Map<String, TValue> named) throws EaterException {
        TValue data = values.get(0);
        if (!data.isJson()) {
            throw new EaterException("Not JSON data", location);
        }
        JsonValue json = data.toJson();
        if (json.isObject()) {
            JsonObject object = (JsonObject)json;
            JsonArray result = new JsonArray();
            for (String key : object.names()) {
                result.add(key);
            }
            return TValue.fromJson(result);
        }
        if (json.isArray()) {
            JsonArray array = (JsonArray)json;
            JsonArray result = new JsonArray();
            for (JsonValue tmp : array) {
                if (!tmp.isObject()) continue;
                JsonObject object = (JsonObject)tmp;
                for (String key : object.names()) {
                    result.add(key);
                }
            }
            return TValue.fromJson(result);
        }
        throw new EaterException("Bad JSON type", location);
    }
}

