/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import com.plantuml.api.cheerpj.WasmLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.acearth.PSystemXearthFactory;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagramFactory;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagramFactory3;
import net.sourceforge.plantuml.api.PSystemFactory;
import net.sourceforge.plantuml.board.BoardDiagramFactory;
import net.sourceforge.plantuml.bpm.BpmDiagramFactory;
import net.sourceforge.plantuml.classdiagram.ClassDiagramFactory;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.dedication.PSystemDedicationFactory;
import net.sourceforge.plantuml.definition.PSystemDefinitionFactory;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagramFactory;
import net.sourceforge.plantuml.directdot.PSystemDotFactory;
import net.sourceforge.plantuml.ditaa.PSystemDitaaFactory;
import net.sourceforge.plantuml.donors.PSystemDonorsFactory;
import net.sourceforge.plantuml.donors.PSystemSkinparameterListFactory;
import net.sourceforge.plantuml.ebnf.PSystemEbnfFactory;
import net.sourceforge.plantuml.eggs.PSystemAppleTwoFactory;
import net.sourceforge.plantuml.eggs.PSystemCharlieFactory;
import net.sourceforge.plantuml.eggs.PSystemColorsFactory;
import net.sourceforge.plantuml.eggs.PSystemEggFactory;
import net.sourceforge.plantuml.eggs.PSystemPathFactory;
import net.sourceforge.plantuml.eggs.PSystemRIPFactory;
import net.sourceforge.plantuml.eggs.PSystemUnsupported;
import net.sourceforge.plantuml.eggs.PSystemWelcomeFactory;
import net.sourceforge.plantuml.emoji.PSystemListEmojiFactory;
import net.sourceforge.plantuml.error.PSystemError;
import net.sourceforge.plantuml.error.PSystemErrorUtils;
import net.sourceforge.plantuml.filesdiagram.FilesDiagramFactory;
import net.sourceforge.plantuml.flowdiagram.FlowDiagramFactory;
import net.sourceforge.plantuml.font.PSystemListFontsFactory;
import net.sourceforge.plantuml.gitlog.GitDiagramFactory;
import net.sourceforge.plantuml.hcl.HclDiagramFactory;
import net.sourceforge.plantuml.help.HelpFactory;
import net.sourceforge.plantuml.jcckit.PSystemJcckitFactory;
import net.sourceforge.plantuml.jsondiagram.JsonDiagramFactory;
import net.sourceforge.plantuml.klimt.creole.legacy.PSystemCreoleFactory;
import net.sourceforge.plantuml.klimt.sprite.ListSpriteDiagramFactory;
import net.sourceforge.plantuml.klimt.sprite.PSystemListInternalSpritesFactory;
import net.sourceforge.plantuml.klimt.sprite.StdlibDiagramFactory;
import net.sourceforge.plantuml.math.PSystemLatexFactory;
import net.sourceforge.plantuml.math.PSystemMathFactory;
import net.sourceforge.plantuml.mindmap.MindMapDiagramFactory;
import net.sourceforge.plantuml.nwdiag.NwDiagramFactory;
import net.sourceforge.plantuml.openiconic.PSystemListOpenIconicFactory;
import net.sourceforge.plantuml.openiconic.PSystemOpenIconicFactory;
import net.sourceforge.plantuml.oregon.PSystemOregonFactory;
import net.sourceforge.plantuml.project.GanttDiagramFactory;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regexdiagram.PSystemRegexFactory;
import net.sourceforge.plantuml.salt.PSystemSaltFactory;
import net.sourceforge.plantuml.security.SecurityProfile;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagramFactory;
import net.sourceforge.plantuml.statediagram.StateDiagramFactory;
import net.sourceforge.plantuml.stats.StatsUtilsIncrement;
import net.sourceforge.plantuml.sudoku.PSystemSudokuFactory;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.timingdiagram.TimingDiagramFactory;
import net.sourceforge.plantuml.utils.Log;
import net.sourceforge.plantuml.version.PSystemLicenseFactory;
import net.sourceforge.plantuml.version.PSystemVersionFactory;
import net.sourceforge.plantuml.wbs.WBSDiagramFactory;
import net.sourceforge.plantuml.wire.WireDiagramFactory;
import net.sourceforge.plantuml.yaml.YamlDiagramFactory;

public class PSystemBuilder {
    public static final long startTime = System.currentTimeMillis();
    private static final List<PSystemFactory> factories = new ArrayList<PSystemFactory>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Diagram createPSystem(List<StringLocated> source, List<StringLocated> rawSource, Map<String, String> skinParam) {
        WasmLog.log("..compiling diagram...");
        long now = System.currentTimeMillis();
        Object result = null;
        try {
            Object object;
            DiagramType type = DiagramType.getTypeFromArobaseStart(source.get(0).getString());
            UmlSource umlSource = UmlSource.createWithRaw(source, type == DiagramType.UML, rawSource);
            for (StringLocated stringLocated : source) {
                if (stringLocated.getPreprocessorError() == null) continue;
                assert (false);
                Log.error("Preprocessor Error: " + stringLocated.getPreprocessorError());
                ErrorUml err = new ErrorUml(ErrorUmlType.SYNTAX_ERROR, stringLocated.getPreprocessorError(), 0, stringLocated.getLocation());
                PSystemError pSystemError = PSystemErrorUtils.buildV2(umlSource, err, Collections.emptyList(), source);
                return pSystemError;
            }
            DiagramType diagramType = umlSource.getDiagramType();
            if (diagramType == DiagramType.UNKNOWN) {
                PSystemUnsupported pSystemUnsupported = new PSystemUnsupported(umlSource);
                return pSystemUnsupported;
            }
            ArrayList<PSystemError> arrayList = new ArrayList<PSystemError>();
            for (PSystemFactory systemFactory : factories) {
                if (diagramType != systemFactory.getDiagramType()) continue;
                Diagram sys = systemFactory.createSystem(umlSource, skinParam);
                if (this.isOk(sys)) {
                    result = sys;
                    Diagram diagram = sys;
                    return diagram;
                }
                arrayList.add((PSystemError)sys);
            }
            if (arrayList.size() == 0) {
                object = new PSystemUnsupported(umlSource);
                return object;
            }
            object = result = PSystemErrorUtils.merge(arrayList);
            return object;
        }
        finally {
            WasmLog.log("...parsing ok...");
            if (result != null && OptionFlags.getInstance().isEnableStats()) {
                StatsUtilsIncrement.onceMoreParse(System.currentTimeMillis() - now, result.getClass());
            }
            Log.info("Compilation duration " + (System.currentTimeMillis() - now));
            RegexConcat.printCacheInfo();
        }
    }

    private boolean isOk(Diagram ps) {
        return ps != null && !(ps instanceof PSystemError);
    }

    static {
        factories.add(new PSystemWelcomeFactory());
        factories.add(new PSystemColorsFactory());
        factories.add(new SequenceDiagramFactory());
        factories.add(new ClassDiagramFactory());
        factories.add(new ActivityDiagramFactory());
        factories.add(new DescriptionDiagramFactory());
        factories.add(new StateDiagramFactory());
        factories.add(new ActivityDiagramFactory3());
        factories.add(new BpmDiagramFactory(DiagramType.BPM));
        factories.add(new PSystemLicenseFactory());
        factories.add(new PSystemVersionFactory());
        factories.add(new PSystemDonorsFactory());
        factories.add(new PSystemSkinparameterListFactory());
        factories.add(new PSystemListFontsFactory());
        factories.add(new PSystemListEmojiFactory());
        factories.add(new PSystemOpenIconicFactory());
        factories.add(new PSystemListOpenIconicFactory());
        factories.add(new PSystemListInternalSpritesFactory());
        factories.add(new PSystemSaltFactory(DiagramType.UML));
        factories.add(new PSystemSaltFactory(DiagramType.SALT));
        factories.add(new PSystemDotFactory(DiagramType.DOT));
        factories.add(new PSystemDotFactory(DiagramType.UML));
        factories.add(new NwDiagramFactory(DiagramType.UML));
        factories.add(new NwDiagramFactory(DiagramType.NW));
        factories.add(new MindMapDiagramFactory());
        factories.add(new WBSDiagramFactory());
        factories.add(new PSystemJcckitFactory());
        factories.add(new PSystemSudokuFactory());
        factories.add(new PSystemDitaaFactory());
        factories.add(new PSystemDefinitionFactory());
        factories.add(new ListSpriteDiagramFactory());
        factories.add(new StdlibDiagramFactory());
        factories.add(new PSystemMathFactory(DiagramType.MATH));
        factories.add(new PSystemLatexFactory(DiagramType.LATEX));
        factories.add(new PSystemCreoleFactory());
        factories.add(new PSystemEggFactory());
        factories.add(new PSystemAppleTwoFactory());
        factories.add(new PSystemRIPFactory());
        if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE) {
            factories.add(new PSystemPathFactory());
        }
        factories.add(new PSystemOregonFactory());
        factories.add(new PSystemCharlieFactory());
        factories.add(new PSystemXearthFactory());
        factories.add(new GanttDiagramFactory());
        factories.add(new FlowDiagramFactory());
        factories.add(new PSystemDedicationFactory());
        factories.add(new TimingDiagramFactory());
        factories.add(new HelpFactory());
        factories.add(new WireDiagramFactory());
        factories.add(new JsonDiagramFactory());
        factories.add(new GitDiagramFactory());
        factories.add(new FilesDiagramFactory());
        factories.add(new BoardDiagramFactory());
        factories.add(new YamlDiagramFactory());
        factories.add(new HclDiagramFactory());
        factories.add(new PSystemEbnfFactory());
        factories.add(new PSystemRegexFactory());
    }
}

