/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.decoration.symbol;

import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.klimt.AbstractShadowable;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphicStencil;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.style.SName;

class USymbolFile
extends USymbol {
    private final HorizontalAlignment stereotypeAlignement = HorizontalAlignment.CENTER;

    USymbolFile() {
    }

    @Override
    public SName getSName() {
        return SName.file;
    }

    private void drawFile(UGraphic ug, double width, double height, double shadowing, double roundCorner) {
        UPath path;
        AbstractShadowable out;
        int cornersize = 10;
        if (roundCorner == 0.0) {
            UPolygon polygon = new UPolygon();
            polygon.addPoint(0.0, 0.0);
            polygon.addPoint(0.0, height);
            polygon.addPoint(width, height);
            polygon.addPoint(width, 10.0);
            polygon.addPoint(width - 10.0, 0.0);
            polygon.addPoint(0.0, 0.0);
            out = polygon;
        } else {
            path = UPath.none();
            path.moveTo(0.0, roundCorner / 2.0);
            path.lineTo(0.0, height - roundCorner / 2.0);
            path.arcTo(new XPoint2D(roundCorner / 2.0, height), roundCorner / 2.0, 0.0, 0.0);
            path.lineTo(width - roundCorner / 2.0, height);
            path.arcTo(new XPoint2D(width, height - roundCorner / 2.0), roundCorner / 2.0, 0.0, 0.0);
            path.lineTo(width, 10.0);
            path.lineTo(width - 10.0, 0.0);
            path.lineTo(roundCorner / 2.0, 0.0);
            path.arcTo(new XPoint2D(0.0, roundCorner / 2.0), roundCorner / 2.0, 0.0, 0.0);
            out = path;
        }
        out.setDeltaShadow(shadowing);
        ug.draw(out);
        path = UPath.none();
        path.moveTo(width - 10.0, 0.0);
        if (roundCorner == 0.0) {
            path.lineTo(width - 10.0, 10.0);
        } else {
            path.lineTo(width - 10.0, 10.0 - roundCorner / 2.0);
            path.arcTo(new XPoint2D(width - 10.0 + roundCorner / 2.0, 10.0), roundCorner / 2.0, 0.0, 0.0);
        }
        path.lineTo(width, 10.0);
        ug.draw(path);
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 10.0, 10.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final Fashion symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, dim);
                ug = symbolContext.apply(ug);
                USymbolFile.this.drawFile(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow(), symbolContext.getRoundCorner());
                USymbol.Margin margin = USymbolFile.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, HorizontalAlignment.CENTER);
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                XDimension2D dimLabel = label.calculateDimension(stringBounder);
                XDimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolFile.this.getMargin().addDimension(dimStereo.mergeTB(dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final Fashion symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                double posStereoY;
                double posStereoX;
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                USymbolFile.this.drawFile(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow(), symbolContext.getRoundCorner());
                XDimension2D dimStereo = stereotype.calculateDimension(ug.getStringBounder());
                if (USymbolFile.this.stereotypeAlignement == HorizontalAlignment.RIGHT) {
                    posStereoX = width - dimStereo.getWidth() - USymbolFile.this.getMargin().getX1() / 2.0;
                    posStereoY = USymbolFile.this.getMargin().getY1() / 2.0;
                } else {
                    posStereoX = (width - dimStereo.getWidth()) / 2.0;
                    posStereoY = 2.0;
                }
                stereotype.drawU(ug.apply(new UTranslate(posStereoX, posStereoY)));
                XDimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
                double posTitle = (width - dimTitle.getWidth()) / 2.0;
                title.drawU(ug.apply(new UTranslate(posTitle, 2.0 + dimStereo.getHeight())));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(width, height);
            }
        };
    }
}

